/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class OpponentsCantSearchLibrariesEffect
extends ContinuousRuleModifyingEffectImpl {
    OpponentsCantSearchLibrariesEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, true, false);
        this.staticText = "Your opponents can't search libraries";
    }

    private OpponentsCantSearchLibrariesEffect(OpponentsCantSearchLibrariesEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public OpponentsCantSearchLibrariesEffect copy() {
        return new OpponentsCantSearchLibrariesEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't search libraries (" + mageObject.getLogName() + " in play).";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return GameEvent.EventType.SEARCH_LIBRARY == event.getType();
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        return controller != null && controller.hasOpponent(event.getPlayerId(), game);
    }
}

