/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.watchers.Watcher;

class PlayerLostLifeNonCombatWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfLifeLostThisTurn = new HashMap<UUID, Integer>();

    PlayerLostLifeNonCombatWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        UUID playerId;
        if (event.getType() == GameEvent.EventType.LOST_LIFE && !event.getFlag() && (playerId = event.getPlayerId()) != null) {
            Integer amount = this.amountOfLifeLostThisTurn.get(playerId);
            amount = amount == null ? Integer.valueOf(event.getAmount()) : Integer.valueOf(amount + event.getAmount());
            this.amountOfLifeLostThisTurn.put(playerId, amount);
        }
    }

    public int getAllOppLifeLost(UUID playerId, Game game) {
        int amount = 0;
        for (UUID opponentId : this.amountOfLifeLostThisTurn.keySet()) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.hasOpponent(playerId, game)) continue;
            amount += this.amountOfLifeLostThisTurn.getOrDefault(opponentId, 0).intValue();
        }
        return amount;
    }

    public void reset() {
        super.reset();
        this.amountOfLifeLostThisTurn.clear();
    }
}

