/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SacrificeEquipedUnlessPaysEffect
extends OneShotEffect {
    protected Cost cost;

    public SacrificeEquipedUnlessPaysEffect(Cost cost) {
        super(Outcome.Sacrifice);
        this.cost = cost;
        this.staticText = "that player sacrifices that creature unless they pay {2}";
    }

    private SacrificeEquipedUnlessPaysEffect(SacrificeEquipedUnlessPaysEffect effect) {
        super((OneShotEffect)effect);
        this.cost = effect.cost.copy();
    }

    public boolean apply(Game game, Ability source) {
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment == null) {
            return false;
        }
        Permanent equipped = game.getPermanent(equipment.getAttachedTo());
        if (equipped == null) {
            return false;
        }
        Player player = game.getPlayer(equipped.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(Outcome.Benefit, "Pay " + this.cost.getText() + "? (Or " + equipped.getName() + " will be sacrificed.)", source, game)) {
            this.cost.clearPaid();
            if (this.cost.pay(source, game, source, equipped.getControllerId(), false, null)) {
                return true;
            }
        }
        equipped.sacrifice(source, game);
        return true;
    }

    public SacrificeEquipedUnlessPaysEffect copy() {
        return new SacrificeEquipedUnlessPaysEffect(this);
    }
}

