/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SadisticShellGameEffect
extends OneShotEffect {
    SadisticShellGameEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with the next opponent in turn order, each player chooses a creature you don't control. Destroy the chosen creatures";
    }

    private SadisticShellGameEffect(SadisticShellGameEffect effect) {
        super((OneShotEffect)effect);
    }

    public SadisticShellGameEffect copy() {
        return new SadisticShellGameEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creature not controlled by " + Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getName).orElse("this spell's controller"));
        filter.add(Predicates.not((Predicate)new ControllerIdPredicate(source.getControllerId())));
        if (!game.getBattlefield().contains((FilterPermanent)filter, source, game, 1)) {
            return false;
        }
        HashSet<Permanent> permanents = new HashSet<Permanent>();
        List playerIds = game.getState().getPlayersInRange(source.getControllerId(), game).stream().distinct().collect(Collectors.toList());
        playerIds.remove(source.getControllerId());
        playerIds.add(source.getControllerId());
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        for (UUID playerId : playerIds) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            target.clearChosen();
            player.choose(Outcome.DestroyPermanent, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            game.informPlayers(player.getLogName() + " chooses to destroy " + permanent.getLogName());
            permanents.add(permanent);
        }
        for (Permanent permanent : permanents) {
            permanent.destroy(source, game);
        }
        return true;
    }
}

