/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveAllCountersSourceCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.players.Player;
import mage.util.CardUtil;

class SageOfHoursEffect
extends OneShotEffect {
    SageOfHoursEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "For each five counters removed this way, take an extra turn after this one";
    }

    private SageOfHoursEffect(SageOfHoursEffect effect) {
        super((OneShotEffect)effect);
    }

    public SageOfHoursEffect copy() {
        return new SageOfHoursEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int countersRemoved = 0;
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof RemoveAllCountersSourceCost)) continue;
                countersRemoved = ((RemoveAllCountersSourceCost)cost).getRemovedCounters();
            }
            int turns = countersRemoved / 5;
            for (int i = 0; i < turns; ++i) {
                game.getState().getTurnMods().add(new TurnMod(player.getId()).withExtraTurn());
            }
            game.informPlayers("Removed " + countersRemoved + " +1/+1 counters: " + player.getLogName() + " takes " + CardUtil.numberToText((int)turns, (String)"an") + (turns > 1 ? " extra turns " : " extra turn ") + "after this one");
            return true;
        }
        return false;
    }
}

