/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;

class SageOfTheMazeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.GATE, "Gates you control");
    private static final DynamicValue xValue = new PermanentsOnBattlefieldCount(filter, Integer.valueOf(2));
    static final Hint hint = new ValueHint("Gates you control", xValue);

    SageOfTheMazeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Until end of turn, target land you control becomes an X/X Citizen creature with haste in addition to its other types, where X is twice the number of Gates you control.";
    }

    private SageOfTheMazeEffect(SageOfTheMazeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SageOfTheMazeEffect copy() {
        return new SageOfTheMazeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int pt = xValue.calculate(game, source, (Effect)this);
        game.addEffect((ContinuousEffect)new BecomesCreatureTargetEffect((Token)new CreatureToken(pt, pt, "").withSubType(SubType.CITIZEN).withAbility((Ability)HasteAbility.getInstance()), false, true, Duration.EndOfTurn), source);
        return true;
    }
}

