/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageItem;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.Target;

class SameCastingCostPredicate
implements ObjectSourcePlayerPredicate<MageItem> {
    SameCastingCostPredicate() {
    }

    public boolean apply(ObjectSourcePlayer<MageItem> input, Game game) {
        StackObject source = game.getStack().getStackObject(input.getSourceId());
        if (source != null) {
            if (source.getStackAbility().getTargets().isEmpty() || ((Target)source.getStackAbility().getTargets().get(0)).getTargets().isEmpty()) {
                return true;
            }
            Permanent firstTarget = game.getPermanent((UUID)((Target)source.getStackAbility().getTargets().get(0)).getTargets().get(0));
            Permanent inputPermanent = game.getPermanent(((MageItem)input.getObject()).getId());
            if (firstTarget != null && inputPermanent != null) {
                return firstTarget.getManaValue() == inputPermanent.getManaValue();
            }
        }
        return true;
    }

    public String toString() {
        return "Target with the same casting cost";
    }
}

