/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.TargetSource;

class SamiteMinistrationEffect
extends PreventionEffectImpl {
    private final TargetSource targetSource;

    public SamiteMinistrationEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that would be dealt to you this turn by a source of your choice. Whenever damage from a black or red source is prevented this way this turn, you gain that much life";
        this.targetSource = new TargetSource();
    }

    private SamiteMinistrationEffect(SamiteMinistrationEffect effect) {
        super((PreventionEffectImpl)effect);
        this.targetSource = effect.targetSource.copy();
    }

    public SamiteMinistrationEffect copy() {
        return new SamiteMinistrationEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.targetSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player;
        PreventionEffectData preventionData = this.preventDamageAction(event, source, game);
        MageObject sourceObject = game.getObject(event.getSourceId());
        if (sourceObject != null && (sourceObject.getColor(game).isBlack() || sourceObject.getColor(game).isRed()) && (player = game.getPlayer(source.getControllerId())) != null) {
            player.gainLife(preventionData.getPreventedDamage(), game, source);
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getControllerId()) && event.getSourceId().equals(this.targetSource.getFirstTarget());
    }
}

