/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class SanctifierEnVecEffect
extends ReplacementEffectImpl {
    SanctifierEnVecEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If a black or red permanent, spell, or card not on the battlefield would be put into a graveyard, exile it instead";
    }

    private SanctifierEnVecEffect(SanctifierEnVecEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public SanctifierEnVecEffect copy() {
        return new SanctifierEnVecEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() == Zone.GRAVEYARD) {
            Permanent permanent = zEvent.getTarget();
            if (permanent != null) {
                return permanent.getColor(game).contains(ObjectColor.BLACK) || permanent.getColor(game).contains(ObjectColor.RED);
            }
            Card card = game.getCard(zEvent.getTargetId());
            if (card != null) {
                return card.getColor(game).contains(ObjectColor.BLACK) || card.getColor(game).contains(ObjectColor.RED);
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        return false;
    }
}

