/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SaprolingBurstToken;
import mage.util.CardUtil;

class SaprolingBurstCreateTokenEffect
extends OneShotEffect {
    SaprolingBurstCreateTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a green Saproling creature token. It has \"This creature's power and toughness are each equal to the number of fade counters on {this}.\"";
    }

    private SaprolingBurstCreateTokenEffect(SaprolingBurstCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public SaprolingBurstCreateTokenEffect copy() {
        return new SaprolingBurstCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        SaprolingBurstToken token = new SaprolingBurstToken(new MageObjectReference(source.getSourceObject(game), game));
        token.putOntoBattlefield(1, game, source, source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            Object object = game.getState().getValue(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)source.getSourceId(), (Game)game));
            HashSet<UUID> tokensCreated = object != null ? (HashSet<UUID>)object : new HashSet<UUID>();
            for (UUID tokenId : token.getLastAddedTokenIds()) {
                tokensCreated.add(tokenId);
            }
            game.getState().setValue(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)source.getSourceId(), (Game)game), tokensCreated);
        }
        return true;
    }
}

