/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SaprolingBurstDestroyEffect
extends OneShotEffect {
    private String cardZoneString;

    SaprolingBurstDestroyEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy all tokens created with {this}. They can't be regenerated";
    }

    private SaprolingBurstDestroyEffect(SaprolingBurstDestroyEffect effect) {
        super((OneShotEffect)effect);
        this.cardZoneString = effect.cardZoneString;
    }

    public SaprolingBurstDestroyEffect copy() {
        return new SaprolingBurstDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object object = game.getState().getValue(this.cardZoneString);
        if (object != null) {
            Set tokensCreated = (Set)object;
            for (UUID tokenId : tokensCreated) {
                Permanent token = game.getPermanent(tokenId);
                if (token == null) continue;
                token.destroy(source, game, true);
            }
        }
        return true;
    }

    public void setCardZoneString(String cardZoneString) {
        this.cardZoneString = cardZoneString;
    }
}

