/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;

class SarkhanSoulAflameEffect
extends OneShotEffect {
    private static final CopyApplier applier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID copyToObjectId) {
            blueprint.setName("Sarkhan, Soul Aflame");
            blueprint.addSuperType(SuperType.LEGENDARY);
            return true;
        }
    };

    SarkhanSoulAflameEffect() {
        super(Outcome.Benefit);
        this.staticText = "have {this} become a copy of it until end of turn, except its name is Sarkhan, Soul Aflame and it's legendary in addition to its other types";
    }

    private SarkhanSoulAflameEffect(SarkhanSoulAflameEffect effect) {
        super((OneShotEffect)effect);
    }

    public SarkhanSoulAflameEffect copy() {
        return new SarkhanSoulAflameEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent creature = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (permanent == null || creature == null) {
            return false;
        }
        game.copyPermanent(Duration.EndOfTurn, creature, source.getSourceId(), source, applier);
        return true;
    }
}

