/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SarkhanTheMadRevealAndDrawEffect
extends OneShotEffect {
    private static final String effectText = "Reveal the top card of your library and put it into your hand. {this} deals damage to himself equal to that card's mana value";

    SarkhanTheMadRevealAndDrawEffect() {
        super(Outcome.DrawCard);
        this.staticText = effectText;
    }

    private SarkhanTheMadRevealAndDrawEffect(SarkhanTheMadRevealAndDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Card card = controller.getLibrary().getFromTop(game);
            Permanent sourcePermanent = game.getPermanent(source.getSourceId());
            if (card != null) {
                controller.moveCards(card, Zone.HAND, source, game);
                if (sourcePermanent != null) {
                    sourcePermanent.damage(card.getManaValue(), source.getSourceId(), source, game, false, false);
                }
                controller.revealCards(sourceObject.getIdName(), (Cards)new CardsImpl(card), game);
            }
            return true;
        }
        return false;
    }

    public SarkhanTheMadRevealAndDrawEffect copy() {
        return new SarkhanTheMadRevealAndDrawEffect(this);
    }
}

