/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SarulfRealmEaterEffect
extends OneShotEffect {
    SarulfRealmEaterEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove all of them. If you do, exile each other nonland permanent with mana value less than or equal to the number of counters removed this way";
    }

    private SarulfRealmEaterEffect(SarulfRealmEaterEffect effect) {
        super((OneShotEffect)effect);
    }

    public SarulfRealmEaterEffect copy() {
        return new SarulfRealmEaterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        int removedThisWay = permanent.removeAllCounters(CounterType.P1P1.getName(), source, game);
        FilterNonlandPermanent filter = new FilterNonlandPermanent();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, removedThisWay));
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game);
        if (!permanents.isEmpty()) {
            player.moveCards(new HashSet(permanents), Zone.EXILED, source, game);
        }
        return true;
    }
}

