/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeBatchEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.stack.Spell;

class SatoruTheInfiltratorTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<ZoneChangeEvent> {
    SatoruTheInfiltratorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), false);
        this.setTriggerPhrase("Whenever {this} and/or one or more other nontoken creatures enter the battlefield under your control, if none of them were cast or no mana was spent to cast them, ");
    }

    protected SatoruTheInfiltratorTriggeredAbility(SatoruTheInfiltratorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SatoruTheInfiltratorTriggeredAbility copy() {
        return new SatoruTheInfiltratorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_BATCH;
    }

    public boolean checkEvent(ZoneChangeEvent event, Game game) {
        if (event.getToZone() != Zone.BATTLEFIELD) {
            return false;
        }
        Permanent permanent = event.getTarget();
        if (permanent == null || !permanent.isControlledBy(this.getControllerId())) {
            return false;
        }
        return permanent.getId().equals(this.getSourceId()) || permanent.isCreature(game) && !(permanent instanceof PermanentToken);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        List moved = this.getFilteredEvents((BatchEvent)((ZoneChangeBatchEvent)event), game);
        if (moved.isEmpty()) {
            return false;
        }
        for (ZoneChangeEvent zce : moved) {
            Spell spell = game.getSpellOrLKIStack(zce.getTargetId());
            if (spell == null || spell.getStackAbility().getManaCostsToPay().getUsedManaToPay().count() <= 0) continue;
            return false;
        }
        return true;
    }
}

