/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class SavageFirecatTriggeredAbility
extends TriggeredAbilityImpl {
    SavageFirecatTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new RemoveCounterSourceEffect(CounterType.P1P1.createInstance()), false);
    }

    private SavageFirecatTriggeredAbility(SavageFirecatTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SavageFirecatTriggeredAbility copy() {
        return new SavageFirecatTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent.isLand(game) && this.isControlledBy(event.getPlayerId());
    }

    public String getRule() {
        return "Whenever you tap a land for mana, remove a +1/+1 counter from {this}.";
    }
}

