/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.cards.s.SavageSummoningWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class SavageSummoningCantCounterEffect
extends ContinuousRuleModifyingEffectImpl {
    private SavageSummoningWatcher watcher;
    private int zoneChangeCounter;

    public SavageSummoningCantCounterEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "That spell can't be countered";
    }

    private SavageSummoningCantCounterEffect(SavageSummoningCantCounterEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.watcher = effect.watcher;
        this.zoneChangeCounter = effect.zoneChangeCounter;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.watcher = (SavageSummoningWatcher)game.getState().getWatcher(SavageSummoningWatcher.class, source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (this.watcher == null || card == null) {
            throw new IllegalArgumentException("Consume Savage watcher or card could not be found");
        }
        this.zoneChangeCounter = card.getZoneChangeCounter(game);
    }

    public SavageSummoningCantCounterEffect copy() {
        return new SavageSummoningCantCounterEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null) {
            return "This creature spell can't be countered (" + sourceObject.getName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && this.watcher.isSpellCastWithThisSavageSummoning(spell.getId(), source.getSourceId(), this.zoneChangeCounter);
    }
}

