/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.s.SavageSummoningWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SavageSummoningEntersBattlefieldEffect
extends ReplacementEffectImpl {
    private SavageSummoningWatcher watcher;
    private int zoneChangeCounter;

    public SavageSummoningEntersBattlefieldEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "That creature enters the battlefield with an additional +1/+1 counter on it";
    }

    private SavageSummoningEntersBattlefieldEffect(SavageSummoningEntersBattlefieldEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.watcher = effect.watcher;
        this.zoneChangeCounter = effect.zoneChangeCounter;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.watcher = (SavageSummoningWatcher)game.getState().getWatcher(SavageSummoningWatcher.class, source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (this.watcher == null || card == null) {
            throw new IllegalArgumentException("Consume Savage watcher or card could not be found");
        }
        this.zoneChangeCounter = card.getZoneChangeCounter(game);
    }

    public SavageSummoningEntersBattlefieldEffect copy() {
        return new SavageSummoningEntersBattlefieldEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature != null) {
            creature.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game, event.getAppliedEffects());
        }
        this.discard();
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(event.getTargetId());
        return card != null && this.watcher.isCardCastWithThisSavageSummoning(card, source.getSourceId(), this.zoneChangeCounter, game);
    }
}

