/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class SawhornNemesisEffect
extends ReplacementEffectImpl {
    SawhornNemesisEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a source would deal damage to the chosen player or a permanent they control, it deals double that damage instead";
    }

    private SawhornNemesisEffect(SawhornNemesisEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public SawhornNemesisEffect copy() {
        return new SawhornNemesisEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID playerId = (UUID)game.getState().getValue(source.getSourceId() + "_player");
        if (playerId == null) {
            return false;
        }
        switch (event.getType()) {
            case DAMAGE_PLAYER: {
                return playerId.equals(event.getTargetId());
            }
            case DAMAGE_PERMANENT: {
                Permanent permanent = game.getPermanent(event.getTargetId());
                if (permanent == null) {
                    return false;
                }
                return playerId.equals(permanent.getControllerId());
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

