/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class SawtoothLoonEffect
extends OneShotEffect {
    SawtoothLoonEffect() {
        super(Outcome.DrawCard);
        this.staticText = "draw two cards, then put two cards from your hand on the bottom of your library";
    }

    private SawtoothLoonEffect(SawtoothLoonEffect effect) {
        super((OneShotEffect)effect);
    }

    public SawtoothLoonEffect copy() {
        return new SawtoothLoonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.drawCards(2, source, game);
            TargetCardInHand target = new TargetCardInHand(2, 2, new FilterCard());
            controller.chooseTarget(Outcome.Detriment, (Target)target, source, game);
            CardsImpl cardsToLibrary = new CardsImpl((Collection)target.getTargets());
            if (!cardsToLibrary.isEmpty()) {
                controller.putCardsOnBottomOfLibrary((Cards)cardsToLibrary, game, source, false);
            }
            return true;
        }
        return false;
    }
}

