/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ScalpelexisEffect
extends OneShotEffect {
    ScalpelexisEffect() {
        super(Outcome.Exile);
        this.staticText = "that player exiles the top four cards of their library. If two or more of those cards have the same name, repeat this process";
    }

    private ScalpelexisEffect(ScalpelexisEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScalpelexisEffect copy() {
        return new ScalpelexisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean doubleName;
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return false;
        }
        HashSet<String> cardNames = new HashSet<String>();
        do {
            doubleName = false;
            CardsImpl toExile = new CardsImpl(targetPlayer.getLibrary().getTopCards(game, 4));
            cardNames.clear();
            for (Card card : toExile.getCards(game)) {
                if (cardNames.contains(card.getName())) {
                    doubleName = true;
                    break;
                }
                cardNames.add(card.getName());
            }
            targetPlayer.moveCards((Cards)toExile, Zone.EXILED, source, game);
        } while (doubleName);
        return true;
    }
}

