/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;

class SchemingSymmetryEffect
extends OneShotEffect {
    SchemingSymmetryEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose two target players. Each of them searches their library for a card, then shuffles and puts that card on top";
    }

    private SchemingSymmetryEffect(SchemingSymmetryEffect effect) {
        super((OneShotEffect)effect);
    }

    public SchemingSymmetryEffect copy() {
        return new SchemingSymmetryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ((Target)source.getTargets().get(0)).getTargets().stream().map(playerId -> game.getPlayer(playerId)).filter(player -> player != null).forEach(player -> {
            TargetCardInLibrary targetCard = new TargetCardInLibrary();
            if (player.searchLibrary(targetCard, source, game)) {
                CardsImpl cards = new CardsImpl();
                cards.add((Object)targetCard.getFirstTarget());
                player.shuffleLibrary(source, game);
                player.putCardsOnTopOfLibrary((Cards)cards, game, source, false);
            }
        });
        return true;
    }
}

