/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ScourgeOfTheSkyclavesEffect
extends OneShotEffect {
    ScourgeOfTheSkyclavesEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player loses half their life, rounded up";
    }

    private ScourgeOfTheSkyclavesEffect(ScourgeOfTheSkyclavesEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScourgeOfTheSkyclavesEffect copy() {
        return new ScourgeOfTheSkyclavesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int lifeToLose = (int)Math.ceil((double)player.getLife() / 2.0);
            player.loseLife(lifeToLose, game, source, false);
        }
        return true;
    }
}

