/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ScoutForSurvivorsEffect
extends OneShotEffect {
    ScoutForSurvivorsEffect() {
        super(Outcome.Benefit);
        this.staticText = "return up to three target creature cards with total mana value 3 or less from your graveyard to the battlefield. Put a +1/+1 counter on each of them";
    }

    private ScoutForSurvivorsEffect(ScoutForSurvivorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScoutForSurvivorsEffect copy() {
        return new ScoutForSurvivorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        cards.retainZone(Zone.GRAVEYARD, game);
        if (player == null || cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        for (Card card : cards.getCards(game)) {
            Optional.ofNullable(CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(), source, game));
        }
        return true;
    }
}

