/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class ScoutsWarningWatcher
extends Watcher {
    private List<String> activeScoutsWarningSpells = new ArrayList<String>();

    public ScoutsWarningWatcher() {
        super(WatcherScope.PLAYER);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && !this.getActiveScoutsWarningSpells().isEmpty() && event.getPlayerId().equals(this.getControllerId()) && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isCreature(game)) {
            this.getActiveScoutsWarningSpells().clear();
        }
    }

    public void addScoutsWarningSpell(UUID sourceId, int zoneChangeCounter) {
        String spellKey = sourceId.toString() + '_' + zoneChangeCounter;
        this.getActiveScoutsWarningSpells().add(spellKey);
    }

    public boolean isScoutsWarningSpellActive(UUID sourceId, int zoneChangeCounter) {
        String spellKey = sourceId.toString() + '_' + zoneChangeCounter;
        return this.getActiveScoutsWarningSpells().contains(spellKey);
    }

    public void reset() {
        super.reset();
        this.getActiveScoutsWarningSpells().clear();
    }

    public List<String> getActiveScoutsWarningSpells() {
        return this.activeScoutsWarningSpells;
    }

    public void setActiveScoutsWarningSpells(List<String> activeScoutsWarningSpells) {
        this.activeScoutsWarningSpells = activeScoutsWarningSpells;
    }
}

