/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class ScrabblingClawsEffect
extends OneShotEffect {
    ScrabblingClawsEffect() {
        super(Outcome.Exile);
        this.staticText = "Target player exiles a card from their graveyard";
    }

    private ScrabblingClawsEffect(ScrabblingClawsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScrabblingClawsEffect copy() {
        return new ScrabblingClawsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer == null) {
            return false;
        }
        FilterCard filter = new FilterCard("card from your graveyard");
        filter.add((Predicate)new OwnerIdPredicate(targetPlayer.getId()));
        TargetCardInGraveyard target = new TargetCardInGraveyard(filter);
        if (!targetPlayer.chooseTarget(Outcome.Exile, (Target)target, source, game)) {
            return false;
        }
        Card card = game.getCard(target.getFirstTarget());
        return card != null && targetPlayer.moveCards(card, Zone.EXILED, source, game);
    }
}

