/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.CantGainLifeRestOfGameTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ScreamingNemesisEffect
extends OneShotEffect {
    ScreamingNemesisEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals that much damage to any other target. If a player is dealt damage this way, they can't gain life for the rest of the game";
    }

    private ScreamingNemesisEffect(ScreamingNemesisEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScreamingNemesisEffect copy() {
        return new ScreamingNemesisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = SavedDamageValue.MUCH.calculate(game, source, (Effect)this);
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        if (amount <= 0 || targetId == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(targetId);
        Player player = game.getPlayer(targetId);
        if (permanent != null) {
            permanent.damage(amount, source.getSourceId(), source, game, false, true);
            return true;
        }
        if (player != null) {
            int damageDone = player.damage(amount, source.getSourceId(), source, game, false, true);
            if (damageDone > 0) {
                game.addEffect(new CantGainLifeRestOfGameTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(player.getId())), source);
            }
            return true;
        }
        return false;
    }
}

