/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class ScreamsFromWithinEffect
extends OneShotEffect {
    ScreamsFromWithinEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return this card from your graveyard to the battlefield";
    }

    private ScreamsFromWithinEffect(ScreamsFromWithinEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card aura = game.getCard(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (aura != null && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD && player != null && player.getGraveyard().contains((Object)source.getSourceId())) {
            for (Permanent creaturePermanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                for (Target target : aura.getSpellAbility().getTargets()) {
                    if (!target.canTarget(creaturePermanent.getId(), source, game)) continue;
                    return player.moveCards(aura, Zone.BATTLEFIELD, source, game);
                }
            }
        }
        return false;
    }

    public ScreamsFromWithinEffect copy() {
        return new ScreamsFromWithinEffect(this);
    }
}

