/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ScroungingBandarEffect
extends OneShotEffect {
    ScroungingBandarEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may move any number of +1/+1 counters from {this} onto another target creature";
    }

    private ScroungingBandarEffect(ScroungingBandarEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScroungingBandarEffect copy() {
        return new ScroungingBandarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent fromPermanent = game.getPermanent(source.getSourceId());
            Permanent toPermanent = game.getPermanent(source.getTargets().getFirstTarget());
            if (fromPermanent != null && toPermanent != null) {
                int amountToMove;
                int amountCounters = fromPermanent.getCounters(game).getCount(CounterType.P1P1);
                if (amountCounters > 0 && (amountToMove = controller.getAmount(0, amountCounters, "How many counters do you want to move?", source, game)) > 0) {
                    fromPermanent.removeCounters(CounterType.P1P1.createInstance(amountToMove), source, game);
                    toPermanent.addCounters(CounterType.P1P1.createInstance(amountToMove), source.getControllerId(), source, game);
                }
                return true;
            }
        }
        return false;
    }
}

