/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class ScryingGlassEffect
extends OneShotEffect {
    public ScryingGlassEffect() {
        super(Outcome.Neutral);
        this.staticText = "Choose a number greater than 0 and a color. Target opponent reveals their hand. If that opponent reveals exactly the chosen number of cards of the chosen color, you draw a card";
    }

    private ScryingGlassEffect(ScryingGlassEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(source.getFirstTarget());
        ChoiceColor color = new ChoiceColor();
        int amount = 0;
        if (controller != null && targetOpponent != null) {
            amount = controller.getAmount(1, Integer.MAX_VALUE, "Choose a number", source, game);
            controller.choose(Outcome.Discard, (Choice)color, game);
            FilterCard filter = new FilterCard();
            filter.add((Predicate)new ColorPredicate(color.getColor()));
            targetOpponent.revealCards(source, targetOpponent.getHand(), game);
            if (targetOpponent.getHand().count(filter, game) == amount) {
                game.informPlayers(controller.getLogName() + " has chosen the exact number and color of the revealed cards from " + targetOpponent.getName() + "'s hand. They draw a card.");
                controller.drawCards(1, source, game);
                return true;
            }
            game.informPlayers(controller.getLogName() + " has chosen incorrectly and will not draw a card.");
        }
        return false;
    }

    public ScryingGlassEffect copy() {
        return new ScryingGlassEffect(this);
    }
}

