/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledCreaturePermanent;

class SculptedSunburstEffect
extends OneShotEffect {
    SculptedSunburstEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature you control, then each opponent chooses a creature they control with equal or lesser power. If you chose a creature this way, exile each creature not chosen by any player this way";
    }

    private SculptedSunburstEffect(SculptedSunburstEffect effect) {
        super((OneShotEffect)effect);
    }

    public SculptedSunburstEffect copy() {
        return new SculptedSunburstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source, game, 1)) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        HashSet<UUID> set = new HashSet<UUID>();
        set.add(permanent.getId());
        int power = permanent.getPower().getValue();
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature you control with power " + power + " or less");
        filter.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, power + 1));
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent;
            if (!game.getBattlefield().contains((FilterPermanent)filter, source, game, 1) || (opponent = game.getPlayer(opponentId)) == null) continue;
            TargetPermanent targetPermanent = new TargetPermanent((FilterPermanent)filter);
            targetPermanent.withNotTarget(true);
            opponent.choose(this.outcome, (Target)targetPermanent, source, game);
            set.add(targetPermanent.getFirstTarget());
        }
        CardsImpl cards = new CardsImpl(game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game));
        cards.removeIf(set::contains);
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        return true;
    }
}

