/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class ScytheSpecterEffect
extends OneShotEffect {
    ScytheSpecterEffect() {
        super(Outcome.Discard);
        this.staticText = "each opponent discards a card. Each player who discarded a card with the highest mana value among cards discarded this way loses life equal to that mana value";
    }

    private ScytheSpecterEffect(ScytheSpecterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<UUID, Card> cardDiscarded = new HashMap<UUID, Card>();
        HashMap<UUID, Integer> discardedCheck = new HashMap<UUID, Integer>();
        Integer highestCMC = 0;
        Integer currentCMC = 0;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(playerId);
                if (opponent == null) continue;
                TargetDiscard target = new TargetDiscard(new FilterCard(), playerId);
                opponent.chooseTarget(Outcome.Discard, (Target)target, source, game);
                Card targetCard = game.getCard(target.getFirstTarget());
                if (targetCard == null) continue;
                currentCMC = targetCard.getManaValue();
                if (highestCMC <= currentCMC) {
                    highestCMC = currentCMC;
                }
                cardDiscarded.put(playerId, targetCard);
            }
            for (UUID opponentId : cardDiscarded.keySet()) {
                Player player = game.getPlayer(opponentId);
                if (player == null || !player.discard((Card)cardDiscarded.get(opponentId), false, source, game)) continue;
                discardedCheck.put(opponentId, 1);
            }
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Player opponent;
                Card card = (Card)cardDiscarded.get(playerId);
                if (card == null || card.getManaValue() != highestCMC.intValue() || (opponent = game.getPlayer(playerId)) == null || (Integer)discardedCheck.get(playerId) != 1) continue;
                opponent.loseLife(highestCMC.intValue(), game, source, false);
            }
            cardDiscarded.clear();
            discardedCheck.clear();
            return true;
        }
        return false;
    }

    public ScytheSpecterEffect copy() {
        return new ScytheSpecterEffect(this);
    }
}

