/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SeaGateStormcallerDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final boolean twice;

    public SeaGateStormcallerDelayedTriggeredAbility(boolean twice) {
        super((Effect)new CopyTargetStackObjectEffect(true), Duration.EndOfTurn, true, false);
        if (twice) {
            this.addEffect((Effect)new CopyTargetStackObjectEffect(true));
        }
        this.twice = twice;
    }

    private SeaGateStormcallerDelayedTriggeredAbility(SeaGateStormcallerDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.twice = ability.twice;
    }

    public SeaGateStormcallerDelayedTriggeredAbility copy() {
        return new SeaGateStormcallerDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getPlayerId().equals(this.getControllerId())) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game) || spell.getManaValue() > 2) {
            return false;
        }
        for (Effect effect : this.getEffects()) {
            effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
        }
        return true;
    }

    public String getRule() {
        return "When you cast your next instant or sorcery spell this turn with mana value 2 or less, copy that spell" + (this.twice ? " twice" : "") + ". You may choose new targets for the cop" + (this.twice ? "ies" : "y") + ".";
    }
}

