/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SeaTrollWatcher
extends Watcher {
    private final Set<MageObjectReference> blockedOrBlockedByBlueThisTurnCreatures = new HashSet<MageObjectReference>();

    public SeaTrollWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.BLOCKER_DECLARED) {
            MageObjectReference blocker = new MageObjectReference(event.getSourceId(), game);
            MageObjectReference attacker = new MageObjectReference(event.getTargetId(), game);
            if (blocker.getPermanentOrLKIBattlefield(game).getColor(game).isBlue()) {
                this.blockedOrBlockedByBlueThisTurnCreatures.add(attacker);
            }
            if (attacker.getPermanentOrLKIBattlefield(game).getColor(game).isBlue()) {
                this.blockedOrBlockedByBlueThisTurnCreatures.add(blocker);
            }
        }
    }

    public void reset() {
        super.reset();
        this.blockedOrBlockedByBlueThisTurnCreatures.clear();
    }

    public boolean blockedOrBlockedByBlueCreatureThisTurn(MageObjectReference creature) {
        return this.blockedOrBlockedByBlueThisTurnCreatures.contains(creature);
    }
}

