/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class SealedFateEffect
extends OneShotEffect {
    SealedFateEffect() {
        super(Outcome.Detriment);
        this.staticText = "Look at the top X cards of target opponent's library. Exile one of those cards and put the rest back on top of that player's library in any order";
    }

    private SealedFateEffect(SealedFateEffect effect) {
        super((OneShotEffect)effect);
    }

    public SealedFateEffect copy() {
        return new SealedFateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (controller == null || opponent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(opponent.getLibrary().getTopCards(game, xValue));
        if (cards.isEmpty()) {
            return false;
        }
        if (cards.size() == 1) {
            return controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        }
        TargetCardInLibrary targetCard = new TargetCardInLibrary();
        controller.choose(this.outcome, (Cards)cards, (TargetCard)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card != null) {
            controller.moveCards(card, Zone.EXILED, source, game);
            cards.remove(card);
        }
        return controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
    }
}

