/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Arrays;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.RandomUtil;

class SearchForSurvivorsEffect
extends OneShotEffect {
    SearchForSurvivorsEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Reorder your graveyard at random. An opponent chooses a card at random in your graveyard. If it's a creature card, put it onto the battlefield. Otherwise, exile it";
    }

    private SearchForSurvivorsEffect(SearchForSurvivorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public SearchForSurvivorsEffect copy() {
        return new SearchForSurvivorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            game.informPlayers("The controller of Search for Survivors will have their graveyard randomized.  A card will be chosen at random from the controller's graveyard.  The result is essentially the same as the card rule");
            UUID[] shuffled = (UUID[])controller.getGraveyard().toArray((Object[])new UUID[0]);
            for (int n = shuffled.length - 1; n > 0; --n) {
                int r = RandomUtil.nextInt((int)(n + 1));
                UUID temp = shuffled[r];
                shuffled[r] = shuffled[n];
                shuffled[n] = temp;
            }
            controller.getGraveyard().clear();
            controller.getGraveyard().addAll(Arrays.asList(shuffled));
            CardsImpl cards = new CardsImpl(controller.getGraveyard().getCards(game));
            if (!cards.isEmpty()) {
                Card card = cards.getRandom(game);
                cards.clear();
                cards.add(card);
                controller.revealCards(source, (Cards)cards, game);
                if (card.isCreature(game)) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                } else {
                    controller.moveCards(card, Zone.EXILED, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

