/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBlockTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SearingBarbEffect
extends OneShotEffect {
    SearingBarbEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's a creature, it can't block this turn";
    }

    private SearingBarbEffect(SearingBarbEffect effect) {
        super((OneShotEffect)effect);
    }

    public SearingBarbEffect copy() {
        return new SearingBarbEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        game.addEffect(new CantBlockTargetEffect(Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

