/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class SearingBlazeTarget
extends TargetPermanent {
    public SearingBlazeTarget() {
        super(1, 1, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, false);
    }

    private SearingBlazeTarget(SearingBlazeTarget target) {
        super((TargetPermanent)target);
    }

    public boolean canTarget(UUID id, Ability source, Game game) {
        Player player = game.getPlayerOrPlaneswalkerController(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        UUID firstTarget = player.getId();
        Permanent permanent = game.getPermanent(id);
        if (firstTarget != null && permanent != null && permanent.isControlledBy(firstTarget)) {
            return super.canTarget(id, source, game);
        }
        return false;
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        Player needPlayer = game.getPlayerOrPlaneswalkerController(source.getFirstTarget());
        if (needPlayer != null) {
            possibleTargets.removeIf(id -> {
                Permanent permanent = game.getPermanent(id);
                return permanent == null || permanent.getId().equals(source.getFirstTarget()) || !permanent.isControlledBy(needPlayer.getId());
            });
        }
        return possibleTargets;
    }

    public SearingBlazeTarget copy() {
        return new SearingBlazeTarget(this);
    }
}

