/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.CouldAttackThisTurnWatcher;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.AttackedThisTurnWatcher;

class SeasonOfTheWitchEffect
extends OneShotEffect {
    SeasonOfTheWitchEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all untapped creatures that didn't attack this turn, except for creatures that couldn't attack";
    }

    private SeasonOfTheWitchEffect(SeasonOfTheWitchEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeasonOfTheWitchEffect copy() {
        return new SeasonOfTheWitchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player activePlayer = game.getPlayer(game.getActivePlayerId());
        if (activePlayer != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                CouldAttackThisTurnWatcher watcher2;
                AttackedThisTurnWatcher watcher;
                if (!permanent.isCreature(game) || permanent.isTapped() || (watcher = (AttackedThisTurnWatcher)game.getState().getWatcher(AttackedThisTurnWatcher.class)) != null && watcher.getAttackedThisTurnCreatures().contains(new MageObjectReference((MageObject)permanent, game)) || (watcher2 = (CouldAttackThisTurnWatcher)game.getState().getWatcher(CouldAttackThisTurnWatcher.class)) != null && !watcher2.getCouldAttackThisTurnCreatures().contains(new MageObjectReference((MageObject)permanent, game))) continue;
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

