/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;

class SeasonsPastTarget
extends TargetCardInYourGraveyard {
    public SeasonsPastTarget() {
        super(0, Integer.MAX_VALUE, new FilterCard("cards with different mana values from your graveyard"));
    }

    private SeasonsPastTarget(SeasonsPastTarget target) {
        super((TargetCardInYourGraveyard)target);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<Integer> usedCMC = new HashSet<Integer>();
        for (UUID targetId : this.getTargets()) {
            Card card = game.getCard(targetId);
            if (card == null) continue;
            usedCMC.add(card.getManaValue());
        }
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        HashSet<UUID> leftPossibleTargets = new HashSet<UUID>();
        for (UUID targetId : possibleTargets) {
            Card card = game.getCard(targetId);
            if (card == null || usedCMC.contains(card.getManaValue())) continue;
            leftPossibleTargets.add(targetId);
        }
        return leftPossibleTargets;
    }

    public boolean canTarget(UUID playerId, UUID objectId, Ability source, Game game) {
        if (super.canTarget(playerId, objectId, source, game)) {
            HashSet<Integer> usedCMC = new HashSet<Integer>();
            for (UUID targetId : this.getTargets()) {
                Card card = game.getCard(targetId);
                if (card == null) continue;
                usedCMC.add(card.getManaValue());
            }
            Card card = game.getCard(objectId);
            return card != null && !usedCMC.contains(card.getManaValue());
        }
        return false;
    }

    public SeasonsPastTarget copy() {
        return new SeasonsPastTarget(this);
    }
}

