/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SecondHarvestEffect
extends OneShotEffect {
    SecondHarvestEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each token you control, create a token that's a copy of that permanent";
    }

    private SecondHarvestEffect(SecondHarvestEffect effect) {
        super((OneShotEffect)effect);
    }

    public SecondHarvestEffect copy() {
        return new SecondHarvestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            FilterControlledPermanent filter = new FilterControlledPermanent("each token you control");
            filter.add((Predicate)TokenPredicate.TRUE);
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, controller.getId(), game)) {
                if (permanent == null) continue;
                CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

