/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.PutIntoGraveFromBattlefieldThisTurnPredicate;
import mage.game.Game;
import mage.players.Player;

class SecondSunriseEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    SecondSunriseEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Each player returns to the battlefield all artifact, creature, enchantment, and land cards in their graveyard that were put there from the battlefield this turn.";
    }

    private SecondSunriseEffect(SecondSunriseEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        boolean result = false;
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            result |= player.moveCards(player.getGraveyard().getCards(filter, source.getControllerId(), source, game), Zone.BATTLEFIELD, source, game);
        }
        return result;
    }

    public SecondSunriseEffect copy() {
        return new SecondSunriseEffect(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
        filter.add((Predicate)PutIntoGraveFromBattlefieldThisTurnPredicate.instance);
    }
}

