/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class SecretSalvageEffect
extends OneShotEffect {
    SecretSalvageEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Exile target nonland card from your graveyard. Search your library for any number of cards with the same name as that card, reveal them, put them into your hand, then shuffle";
    }

    private SecretSalvageEffect(SecretSalvageEffect effect) {
        super((OneShotEffect)effect);
    }

    public SecretSalvageEffect copy() {
        return new SecretSalvageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card targetCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetCard == null) {
            return false;
        }
        controller.moveCards(targetCard, Zone.EXILED, source, game);
        String nameToSearch = CardUtil.getCardNameForSameNameSearch((Card)targetCard);
        FilterCard nameFilter = new FilterCard("card named " + nameToSearch);
        nameFilter.add((Predicate)new NamePredicate(nameToSearch));
        return new SearchLibraryPutInHandEffect(new TargetCardInLibrary(0, Integer.MAX_VALUE, nameFilter), true).apply(game, source);
    }
}

