/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControllerEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class SehtsTigerEffect
extends OneShotEffect {
    SehtsTigerEffect() {
        super(Outcome.Protect);
        this.staticText = "you gain protection from the color of your choice until end of turn. <i>(You can't be targeted, dealt damage, or enchanted by anything of the chosen color.)</i>";
    }

    private SehtsTigerEffect(SehtsTigerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        ChoiceColor choice = new ChoiceColor();
        if (controller != null && mageObject != null && controller.choose(Outcome.Protect, (Choice)choice, game)) {
            game.informPlayers(mageObject.getLogName() + ": " + controller.getLogName() + " has chosen " + choice.getChoice());
            FilterCard filter = new FilterCard();
            filter.add((Predicate)new ColorPredicate(choice.getColor()));
            filter.setMessage(choice.getChoice());
            ProtectionAbility ability = new ProtectionAbility((Filter)filter);
            game.addEffect((ContinuousEffect)new GainAbilityControllerEffect((Ability)ability, Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }

    public SehtsTigerEffect copy() {
        return new SehtsTigerEffect(this);
    }
}

