/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.GreatestPowerPredicate;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SelvalaHeartOfTheWildsEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter2 = new FilterCreaturePermanent();

    SelvalaHeartOfTheWildsEffect() {
        super(Outcome.Benefit);
        this.staticText = "its controller may draw a card if its power is greater than each other creature's power";
    }

    private SelvalaHeartOfTheWildsEffect(SelvalaHeartOfTheWildsEffect effect) {
        super((OneShotEffect)effect);
    }

    public SelvalaHeartOfTheWildsEffect copy() {
        return new SelvalaHeartOfTheWildsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            Player permanentController;
            if (filter2.match((Object)permanent, game) && (permanentController = game.getPlayer(permanent.getControllerId())) != null && permanentController.chooseUse(Outcome.DrawCard, "Draw a card?", source, game)) {
                permanentController.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter2.add((Predicate)new GreatestPowerPredicate());
    }
}

