/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class SelvalasStampedeEffect
extends OneShotEffect {
    SelvalasStampedeEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Council's dilemma</i> &mdash; Starting with you, each player votes for wild or free. Reveal cards from the top of your library until you reveal a creature card for each wild vote. Put those creature cards onto the battlefield, then shuffle the rest into your library. You may put a permanent card from your hand onto the battlefield for each free vote";
    }

    private SelvalasStampedeEffect(SelvalasStampedeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SelvalasStampedeEffect copy() {
        return new SelvalasStampedeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TwoChoiceVote vote = new TwoChoiceVote("Wild (from library to battlefield)", "Free (from hand to battlefield)", Outcome.Detriment);
        vote.doVotes(source, game);
        int wildCount = vote.getVoteCount((Object)true);
        int freeCount = vote.getVoteCount((Object)false);
        CardsImpl toReveal = new CardsImpl();
        CardsImpl creatureCards = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            if (creatureCards.size() >= wildCount) break;
            if (card.isCreature(game)) {
                creatureCards.add(card);
            }
            toReveal.add(card);
        }
        if (toReveal.size() > 0) {
            player.revealCards(source, (Cards)toReveal, game);
        }
        if (creatureCards.size() > 0) {
            player.moveCards((Cards)creatureCards, Zone.BATTLEFIELD, source, game);
        }
        player.shuffleLibrary(source, game);
        if (freeCount > 0) {
            TargetCardInHand target = new TargetCardInHand(0, freeCount, (FilterCard)StaticFilters.FILTER_CARD_PERMANENT);
            player.choose(Outcome.PutCreatureInPlay, player.getHand(), (TargetCard)target, source, game);
            creatureCards.clear();
            creatureCards.addAll((Collection)target.getTargets());
            player.moveCards((Cards)creatureCards, Zone.BATTLEFIELD, source, game);
        }
        return wildCount + freeCount > 0;
    }
}

