/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class SemblanceAnvilCostReductionEffect
extends CostModificationEffectImpl {
    private static final String effectText = "Spells you cast that share a card type with the exiled card cost {2} less to cast";

    SemblanceAnvilCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = effectText;
    }

    private SemblanceAnvilCostReductionEffect(SemblanceAnvilCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        CardUtil.adjustCost((SpellAbility)spellAbility, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        List imprinted;
        Permanent permanent;
        Card spellCard;
        if (abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId()) && (spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game)) != null && (permanent = game.getPermanent(source.getSourceId())) != null && (imprinted = permanent.getImprinted()) != null && !imprinted.isEmpty()) {
            Card imprintedCard = game.getCard((UUID)imprinted.get(0));
            return imprintedCard != null && imprintedCard.shareTypes(spellCard, game);
        }
        return false;
    }

    public SemblanceAnvilCostReductionEffect copy() {
        return new SemblanceAnvilCostReductionEffect(this);
    }
}

