/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class SemestersEndReturnEffect
extends OneShotEffect {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    SemestersEndReturnEffect(Cards cards, Game game) {
        super(Outcome.Benefit);
        this.staticText = "return the exiled card to the battlefield";
        cards.stream().map(uuid -> new MageObjectReference(uuid, game)).forEach(this.morSet::add);
    }

    private SemestersEndReturnEffect(SemestersEndReturnEffect effect) {
        super((OneShotEffect)effect);
        this.morSet.addAll(effect.morSet);
    }

    public SemestersEndReturnEffect copy() {
        return new SemestersEndReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        this.morSet.stream().map(mor -> mor.getCard(game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
        cards.retainZone(Zone.BATTLEFIELD, game);
        if (cards.isEmpty()) {
            return false;
        }
        cards.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).forEach(p -> {
            if (p.isCreature(game)) {
                p.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
            }
            if (p.isPlaneswalker(game)) {
                p.addCounters(CounterType.LOYALTY.createInstance(), source.getControllerId(), source, game);
            }
        });
        return true;
    }
}

