/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class SenTripletsRuleModifyingEffect
extends ContinuousRuleModifyingEffectImpl {
    SenTripletsRuleModifyingEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "choose target opponent. This turn, that player can't cast spells or activate abilities";
    }

    private SenTripletsRuleModifyingEffect(SenTripletsRuleModifyingEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SenTripletsRuleModifyingEffect copy() {
        return new SenTripletsRuleModifyingEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject mageObject = game.getObject(source);
        if (targetPlayer != null && mageObject != null) {
            return "This turn you can't cast spells or activate abilities (" + mageObject.getLogName() + ')';
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL || event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(this.getTargetPointer().getFirst(game, source));
    }
}

