/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SenseisDiviningTopEffect
extends OneShotEffect {
    SenseisDiviningTopEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = ", then put {this} on top of its owner's library";
    }

    private SenseisDiviningTopEffect(SenseisDiviningTopEffect effect) {
        super((OneShotEffect)effect);
    }

    public SenseisDiviningTopEffect copy() {
        return new SenseisDiviningTopEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player owner = game.getPlayer(game.getOwnerId(source.getSourceId()));
        if (permanent != null && owner != null) {
            return owner.putCardsOnTopOfLibrary((Card)permanent, game, source, true);
        }
        return false;
    }
}

